<?php
/*--------------------------------------------------------------------------------------------------
    PropertyQuantityReader.php 2020-03-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Readers;

use Doctrine\DBAL\Connection;
use Gambio\Shop\Properties\Properties\ValueObjects\CombinationId;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Entities\CombinationQuantity;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Entities\PropertyTotalQuantity;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Exceptions\ProductDoesntUsePropertyQuantityException;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitId;
use ProductDataInterface;

class PropertyQuantityReader implements PropertyQuantityReaderInterface
{
    /**
     * @var bool
     */
    private $attributeStockCheck;
    /**
     * @var Connection
     */
    private $connection;
    /**
     * @var bool
     */
    private $stockCheck;
    
    
    /**
     * PropertyQuantityReader constructor.
     *
     * @param Connection $connection
     */
    public function __construct(
        Connection $connection
    ) {
        $this->connection          = $connection;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getQuantityByCombinationId(int $combinationId): ?float
    {
        $data = $this->connection->createQueryBuilder()
                                 ->select('combi_quantity')
                                 ->from('products_properties_combis')
                                 ->where('products_properties_combis_id = :products_properties_combis_id')
                                 ->setParameter('products_properties_combis_id', $combinationId)
                                 ->execute()
                                 ->fetchAll();
        foreach ($data as $row) {
            return (float)$row['combi_quantity'];
        }
        return null;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getTotalQuantityForProduct(int $productId): ?float
    {
        $data = $this->connection->createQueryBuilder()
                                 ->select('sum(combi_quantity) combi_quantity')
                                 ->from('products_properties_combis')
                                 ->where('products_id = :products_id')
                                 ->setParameter('products_id', $productId)
                                 ->execute()
                                 ->fetchAll();
        foreach ($data as $row) {
            return  (float)$row['combi_quantity'];
            
        }
        return null;
    }
}